#!/bin/sh
# Copyright (c) 2000-2014 Synology Inc. All rights reserved.
HttpdConf="/etc/httpd/conf/httpd.conf-sys"
HttpdSSLConf="/etc/httpd/conf/extra/httpd-ssl.conf-sys"
HttpdSSLConfCipher="/etc/httpd/conf/extra/httpd-ssl.conf-cipher"
SitesAvailableDir="/etc/httpd/sites-available"
SitesEnabledDir="/etc/httpd/sites-enabled"
INTERCRT="/usr/syno/etc/ssl/ssl.intercrt/server-ca.crt"
FrameOptionsConf="/etc/httpd/conf/extra/httpd-frameOptions.conf-sys"

GenerateSSLCert()
{
	/usr/syno/etc.defaults/rc.ssl_keygen > /dev/null 2>&1
	/usr/syno/etc.defaults/rc.cgi_keygen > /dev/null 2>&1 &
}

ClearDesktopSession()
{
	local sess_file=/usr/syno/etc/private/session/current.users
	local sess_tmp_file=/tmp/.session.current.users.$$

	# /var/.UpgradeBootup will be deleted by S99zbootok.sh
	test -f "/var/.UpgradeBootup" || return 0
	# upgrade from 4.3 to 5.0, session file doesn't exist
	test -f $sess_file || return 0

	# clear desktop user session only
	# remove record in session file
	/bin/grep -v "\"app\": \"current.users\"" $sess_file > $sess_tmp_file
	/bin/mv $sess_tmp_file $sess_file
}

# access time file will be left in some situations
ClearRedundantAccessTimeFile()
{
	local sess_file=/usr/syno/etc/private/session/current.users
	local sess_sid_list=
	local sess_access_dir=/usr/syno/etc/private/session/current.users.access.time/
	local sess_access_list=$(ls -A $sess_access_dir)

	# upgrade from 4.3 to 5.0, session file doesn't exist
	test -f "$sess_file" || return 0
	test -z "$sess_access_list" && return 0
	sess_sid_list=$(sed 's/^.*\"id\": \"\([^"]*\)\".*$/#\1#/g' $sess_file | tr -d "\r\n ")

	# remove redundant access time file
	if [ -z "$sess_sid_list" ]; then
		for sid in $sess_access_list
		do
			/bin/rm -f "$sess_access_dir$sid"
		done
	else
		for sid in $sess_access_list
		do
			echo "$sess_sid_list" | grep "#$sid#" > /dev/null || /bin/rm -f "$sess_access_dir$sid"
		done
	fi
}

GenerateConf()
{
	ADMIN_PORT=$(/bin/get_key_value /etc/synoinfo.conf admin_port)
	if [ -z "$ADMIN_PORT" ]; then
		ADMIN_PORT=$(/bin/get_key_value /etc.defaults/synoinfo.conf admin_port)
		if [ -z "$ADMIN_PORT" ]; then
			ADMIN_PORT="5000"
		fi
	fi
	ADMIN_SSL_PORT=$(/bin/get_key_value /etc/synoinfo.conf secure_admin_port)
	if [ -z "$ADMIN_SSL_PORT" ]; then
		ADMIN_SSL_PORT=$(/bin/get_key_value /etc.defaults/synoinfo.conf secure_admin_port)
		if [ -z "$ADMIN_SSL_PORT" ]; then
			ADMIN_SSL_PORT="5001"
		fi
	fi

	cp -f ${HttpdConf} ${HttpdConf}.$$
	if [ $? -ne 0 ]; then
		logger -p user.err -t "$(basename "$0")" "backup ${HttpdConf} failed."
		rm -f ${HttpdConf}.$$
		return 1
	fi
	sed -e "/^Listen/c\\Listen ${ADMIN_PORT}" \
		-e "/^ServerName/c\\ServerName *:${ADMIN_PORT}" \
		-e "/redirect.cgi?/c\\	RewriteRule ^/(.*)$ /usr/syno/synoman/redirect.cgi?${ADMIN_PORT}" \
		${HttpdConf} > ${HttpdConf}.$$
	if [ -s "${HttpdConf}.$$" ]; then
		mv ${HttpdConf}.$$ ${HttpdConf}
	fi

	cp -f ${HttpdSSLConf} ${HttpdSSLConf}.$$
	if [ $? -ne 0 ]; then
		logger -p user.err -t "$(basename "$0")" "backup ${HttpdSSLConf} failed."
		rm -f ${HttpdSSLConf}.$$
		return 1
	fi

	sed -e "/^Listen/c\\Listen ${ADMIN_SSL_PORT}" \
		-e "/^<VirtualHost/c\\<VirtualHost *:${ADMIN_SSL_PORT}>" \
		-e "/redirect.cgi?/c\\	RewriteRule ^/(.*)$ /usr/syno/synoman/redirect.cgi?${ADMIN_SSL_PORT}" \
		${HttpdSSLConf} > ${HttpdSSLConf}.$$
	if [ -s "${HttpdSSLConf}.$$" ]; then
		mv ${HttpdSSLConf}.$$ ${HttpdSSLConf}
	fi
	rm -f ${HttpdConf}.$$ ${HttpdSSLConf}.$$ 2>/dev/null

	if [ -s ${HttpdSSLConfCipher} ]; then
		if [ -f "$INTERCRT" ]; then
			sed -e "/^#SSLCertificateChainFile/c\\SSLCertificateChainFile /usr/syno/etc/ssl/ssl.intercrt/server-ca.crt" \
			${HttpdSSLConfCipher} > ${HttpdSSLConfCipher}.$$
		else
			sed -e "/^SSLCertificateChainFile/c\\\#SSLCertificateChainFile /usr/syno/etc/ssl/ssl.intercrt/server-ca.crt" \
			${HttpdSSLConfCipher} > ${HttpdSSLConfCipher}.$$
		fi

		if [ -s "${HttpdSSLConfCipher}.$$" ]; then
			mv ${HttpdSSLConfCipher}.$$ ${HttpdSSLConfCipher}
		fi

		rm -f ${HttpdSSLConfCipher}.$$ 2>/dev/null
	fi

	FRAME_OPTIONS_BUILT_IN_ALLOW_URL=$(/bin/get_key_value /etc.defaults/synoinfo.conf frame_options_built_in_allow_url)
	FRAME_OPTIONS_ALLOW_URL=$(/bin/get_key_value /etc/synoinfo.conf frame_options_allow_url)
	FRAME_OPTIONS_DENY_URL=$(/bin/get_key_value /etc.defaults/synoinfo.conf frame_options_deny_url)

	touch ${FrameOptionsConf}.$$
	if [ $? -ne 0 ]; then
		logger -p user.err -t "$(basename "$0")" "create ${FrameOptionsConf}.$$ failed."
		return 1
	fi

	AllowUrls=$(echo "${FRAME_OPTIONS_BUILT_IN_ALLOW_URL}, ${FRAME_OPTIONS_ALLOW_URL}" | sed 's/ //g')
	DenyUrls=$(echo "${FRAME_OPTIONS_DENY_URL}" | sed 's/ //g')
	IFS_BACKUP="$IFS"
	IFS=,
	for url in ${DenyUrls}
	do
		if [ -n "${url}" ]; then
			echo "SetEnvIfNoCase Referer \"^http[s]?://$url\" denyurl" >> ${FrameOptionsConf}.$$
		fi
	done

	for url in ${AllowUrls}
	do
		if [ -n "${url}" ]; then
			echo "SetEnvIfNoCase Referer \"^http[s]?://$url\" skipurl" >> ${FrameOptionsConf}.$$
		fi
	done

	echo "Header set X-Frame-Options SAMEORIGIN env=!skipurl" >> ${FrameOptionsConf}.$$
	echo "Header set X-Frame-Options DENY env=denyurl" >> ${FrameOptionsConf}.$$
	if [ -s "${FrameOptionsConf}.$$" ]; then
		mv ${FrameOptionsConf}.$$ ${FrameOptionsConf}
	fi
	rm -f ${FrameOptionsConf}.$$ 2>/dev/null

	IFS="$IFS_BACKUP"
}

MigrateAltPortConfByPath()
{
	local OldConf="$1"
	local DsmAppName="$2"
	local Template="$3"
	local NewConfName="$4"
	local PortKey="$5"

	if [ ! -f "$OldConf" ]; then
		return 1
	fi

	local Port=$(/bin/sed -n "s,Listen \([0-9]\+\),\1,p" "$OldConf"  2>/dev/null)

	if [ -n "$Port" ]; then
		mv "$OldConf" "$OldConf.bak"

		cp -f "$Template" "$SitesAvailableDir/$NewConfName"

		/bin/sed -i "s,{$PortKey},$Port,g" "$SitesAvailableDir/$NewConfName"
		/bin/sed -i "s,{DSM_APP_NAME},$DsmAppName,g" "$SitesAvailableDir/$NewConfName"

		ln -sf "$SitesAvailableDir/$NewConfName" "$SitesEnabledDir/$NewConfName"
	fi
}

MigrateAltPortConfHttp()
{
	local OldConf="$1"
	local DsmAppName="$2"
	local Template="/etc/httpd/conf/extra/httpd-template-alt-port.conf"
	local NewConfName="$DsmAppName.alt_port.conf"
	local PortKey="HTTP_PORT"

	MigrateAltPortConfByPath "$OldConf" "$DsmAppName" "$Template" "$NewConfName" "$PortKey"
}

MigrateAltPortConfSsl()
{
	local OldConf="$1"
	local DsmAppName="$2"
	local Template="/etc/httpd/conf/extra/httpd-template-alt-port-ssl.conf"
	local NewConfName="$DsmAppName.alt_port_ssl.conf"
	local PortKey="HTTPS_PORT"

	MigrateAltPortConfByPath "$OldConf" "$DsmAppName" "$Template" "$NewConfName" "$PortKey"
}

MigrateAltPortConf()
{
	local FileStationConf="/etc/httpd/conf/extra/httpd-filestation.conf-sys"
	local FileStationSslConf="/etc/httpd/conf/extra/httpd-ssl-filestation.conf-sys"
	local FileStationDsmAppName="SYNO.SDS.App.FileStation3.Instance"
	local SurveillanceStationConf="/etc/httpd/conf/extra/httpd-surveillancestation.conf-sys"
	local SurveillanceStationSslConf="/etc/httpd/conf/extra/httpd-ssl-surveillancestation.conf-sys"
	local SurveillanceStationDsmAppName="SYNO.SDS.SurveillanceStation"

	# migrate File Station conf
	MigrateAltPortConfHttp $FileStationConf $FileStationDsmAppName
	MigrateAltPortConfSsl $FileStationSslConf $FileStationDsmAppName

	# migrate Surveillance Station conf
	MigrateAltPortConfHttp $SurveillanceStationConf $SurveillanceStationDsmAppName
	MigrateAltPortConfSsl $SurveillanceStationSslConf $SurveillanceStationDsmAppName
}

CheckSitesEnabledConf()
{
	# check all symbolic link not broken
	local files=$(/usr/bin/find "$SitesEnabledDir" -name "*.conf" 2>/dev/null)
	for f in $files
	do
		if [ ! -r "$f" ]; then
			rm "$f"
		fi
	done
}

GenerateSSLCert
ClearDesktopSession
ClearRedundantAccessTimeFile
GenerateConf
MigrateAltPortConf
CheckSitesEnabledConf
